#include "pch.h"

#include "aGe.h"
//------------------------------------------------------------------------------
double aGe::ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="A.H. Clark";
		ipRef->title="Electrical and optical properties of amorphous germanium";
		ipRef->journal="Phys. Rev., vol. 154, no. 3, pp. 750-757, 1967.";
		ipRef->comment="-";
	}
	return ( 1./er(iT) );       
}
//------------------------------------------------------------------------------
double aGe::er(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="A.H. Clark";
		ipRef->title="Electrical and optical properties of amorphous germanium";
		ipRef->journal="Phys. Rev., vol. 154, no. 3, pp. 750-757, 1967.";
		ipRef->comment="tylko wartosc dla RT";
	}
	return ( 3. );       
}
//------------------------------------------------------------------------------
double aGe::k(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="T. Tritt";
		ipRef->title="Thermal Conductivity, Theory, Properties and Applications";
		ipRef->journal="p. 138. chapter 1.5";
		ipRef->comment="Lukasz Piskorski - na podst. danych eksp. z Rys. 15";
	}
	return ( -3.18e-6*(iT-300.)*(iT-300.) - 2.74e-4*(iT-300.) + 5.06e-1 );       
}
//------------------------------------------------------------------------------
double aGe::nR(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="R.N. Kre et al. International Journal of the Physical Sciences 5 (2010) 675-682";
		ipRef->title="N. Do et al., APL 60 (1992) 2186-2188";
		ipRef->journal="-";
		ipRef->comment="Lukasz Piskorski - na podst. danych eksp. z prac:";
	}
	if (iLam >= 2000.) // 4.05.2014 (2.25-5 um)
		return ( 4.205+0.126/(1.-1.669*pow(cFunc::LamtoE(iLam),2.)) ); // Lukasz na podstawie danych eksp.: Arafin (2013), PhD, Electrically ..., p. 73
	else
		return 0.;
}
//---------------------------------------------------------------------------
double aGe::abs(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="-";
	}
	if (iLam > 1240.)
		return ( exp(2.37 + 8.25*cFunc::LamtoE(iLam) - 0.94*pow(cFunc::LamtoE(iLam),2.)) ); // Lukasz na podstawie danych eksp.: Arafin (2013), PhD, Electrically ..., Fig. 5.7, p. 82 (1.24-2.7 um)
	else
		return 0.;
}
//------------------------------------------------------------------------------
aGe::aGe()
{  
}
//------------------------------------------------------------------------------
aGe::~aGe()
{
}
//------------------------------------------------------------------------------
