#include "pch.h"

#include "aSi.h"
//------------------------------------------------------------------------------
double aSi::k(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="Lukasz Piskorski";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="na podstawie danych eksp. z pracy: D.G. Cahill et al., Physical Review B 50 (1994) 6077-6081";
	}
	return ( -0.73*pow(iT/300.,-0.67) - 0.29*(iT/300.) + 2.63 );       
}
//------------------------------------------------------------------------------
double aSi::nR(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="Lukasz Piskorski";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="na podst. danych eksp. z prac: R.N. Kre et al., International Journal of the Physical Sciences 5 (2010) 675-682 i N. Do et al., APL 60 (1992) 2186-2188";
	}
	double tLam = iLam*1e-3; // 1e-3: nm-> um
	double tnR300K = 0.27/pow(tLam,4.1)+3.835; // Lukasz na podstawie danych eksp.: R.N. Kre et al., International Journal of the Physical Sciences 5 (2010) 675-682
	if (iLam > 1050)
		return ( tnR300K + (8.5e-5/pow(tLam,5.9))*(iT-300.) ); // Lukasz na podstawie danych eksp.: N. Do et al., Appl. Phys. Lett. 60 (1992) 2186-2188
	else
		return 0.;
}
//------------------------------------------------------------------------------
aSi::aSi()
{  
}
//------------------------------------------------------------------------------
aSi::~aSi()
{
}
//------------------------------------------------------------------------------
