#include "pch.h"

#include "aSiO2.h"
//------------------------------------------------------------------------------
double aSiO2::ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="www.siliconfareast.com/sio2si3n4.htm";
		ipRef->comment="brak zaleznosci od temperatury"; 
	}
	return ( 1e-13 );       
}
//------------------------------------------------------------------------------
double aSiO2::k(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="Lukasz Piskorski";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="na podstawie danych eksp. z pracy: D.G. Cahill, Review of Scientific Instruments 61 (2) 802-808 (1990)";
	}
	return ( 2.66*pow(iT/300.,0.53) - 0.82*(iT/300.) - 0.55 );       
}
//------------------------------------------------------------------------------
double aSiO2::nR(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="I.H. Malitson";
		ipRef->title="Interspecimen comparison of the refractive index of fused silica";
		ipRef->journal="Journal of the Optical Society of America, vol. 55, no. 10, pp. 1205-1209, 1965";
		ipRef->comment="wyznaczenie zaleznosci od temp. na podstawie danych eksp. z tej samej pracy: Lukasz Piskorski"; 
	}
	double tLam = iLam*1e-3; // 1e-3: nm-> um
	double tnR293K = sqrt( 1.+0.6961663*tLam*tLam/(tLam*tLam-pow(0.0684043,2.)) + 0.4079426*tLam*tLam/(tLam*tLam-pow(0.1162414,2.))
		+ 0.8974794*tLam*tLam/(tLam*tLam-pow(9.896161,2.)) );
	if (iLam > 210.)
		return ( tnR293K + ((0.08*tLam+0.01)/pow(tLam,3.5)+13.2*pow(tLam,0.69)-7.4*tLam+4.9)*1e-6*(iT-293.) );
	else
		return 0.;
}
//------------------------------------------------------------------------------
aSiO2::aSiO2()
{  
}
//------------------------------------------------------------------------------
aSiO2::~aSiO2()
{
}
//------------------------------------------------------------------------------
