#include "pch.h"

#include "cSi.h"
//------------------------------------------------------------------------------
double cSi::k(double iT, reference *ipRef)
{
  return 150. * pow(300./iT, 1.3);
}
//------------------------------------------------------------------------------
double cSi::n(double iT, double iNdop, std::string iDop, reference *ipRef)
{
	/*double tn300K = 0.;
	if (iDop == "P" || iDop == "As" || iDop == "Sb")
		tn300K = iNdop;
	else if (iDop == "B")
		tn300K = iNdop;
	else
		tn300K = 0.;
	return tn300K;*/
	return (iNdop);
}

//------------------------------------------------------------------------------
double cSi::mob(double iT, double iNdop, std::string iDop, reference *ipRef)
{
	//double tn = n(iT,iNdop,iDop) * 1e-6;
	double tmob300K = 0.;
	if (iDop == "P" || iDop == "As" || iDop == "Sb")
		tmob300K = 88.*pow(iT/300.,-0.57) + 7.4e8*pow(iT,-2.33) / (1. + (iNdop/(1.26e23*pow(iT/300.,2.4))) * 0.88*pow(iT/300.,-0.146));
	else if (iDop == "B")
		tmob300K = 54.3*pow(iT/300.,-0.57) + 1.36e8*pow(iT,-2.23) / (1. + (iNdop/(2.35e23*pow(iT/300.,2.4))) * 0.88*pow(iT/300.,-0.146));
	return ( tmob300K * 1e-4 ); 
}
//------------------------------------------------------------------------------
double cSi::ec(double iT, double iNdop, std::string iDop, reference *ipRef) 
{
	return cPhys::e * n(iT,iNdop,iDop) * mob(iT,iNdop,iDop);
}
//------------------------------------------------------------------------------
cSi::cSi()
{  
}
//------------------------------------------------------------------------------
cSi::~cSi()
{
}
//------------------------------------------------------------------------------
