#include "pch.h"

#include "diament.h"
//---------------------------------------------------------------------------
diament::diament(double tRT)
{
	mkRT = tRT;
	msigmaRT = tRT;
}
//---------------------------------------------------------------------------
double diament::ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="-";
	}
	return ( msigmaRT*pow(iT/300., 0) );
}
//---------------------------------------------------------------------------
double diament::k(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Barman and G. P. Srivastava";
		ipRef->title="Temperature dependence of the thermal conductivity of different forms of diamond";
		ipRef->journal="Journal of Applied Physics 101 (2007) 123507";
		ipRef->comment="zaleznosc temperaturowa dla diamentu naturalnego kRT = 2200 W/mK";
	}
	return ( mkRT*pow(iT/300., -1.0) );
}
//---------------------------------------------------------------------------
double diament::cp(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment=" ";
	}
	return ( 0.5148e3 );
}
//---------------------------------------------------------------------------
double diament::g(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S. Adachi";
		ipRef->title="Properties of Semiconductors Alloys";
		ipRef->journal="John Wiley and Sons, 2009";
		ipRef->comment=" ";
	}
	return ( 3.5156e3 );
}
