#include "pch.h"

#include "powietrze.h"
//------------------------------------------------------------------------------
double powietrze::ec(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S.D. Pawar, P. Murugavel and D.M. Lal";
		ipRef->title="Effect of relative humidity and sea level pressure on electrical conductivity of air over Indian Ocean";
		ipRef->journal="Journal of Geophysical Research, vol. 114, no. D2, id. D02205 (8 pp.), 2009";
		ipRef->comment="wartosc srednia z przedzialu (0.3-0.8)*10^-14 S/m";
	}
	return ( 0.55e-14 );
}
//------------------------------------------------------------------------------
double powietrze::er(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="S.D. Pawar, P. Murugavel and D.M. Lal";
		ipRef->title="Effect of relative humidity and sea level pressure on electrical conductivity of air over Indian Ocean";
		ipRef->journal="Journal of Geophysical Research, vol. 114, no. D2, id. D02205 (8 pp.), 2009";
		ipRef->comment="wartosc wyznaczona na podstawie przewodnosci elektrycznej";
	}
	return ( 1. / ec(iT) );
}
//------------------------------------------------------------------------------
double powietrze::k(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 6, pp. 175 (in pdf: 1198)";
		ipRef->comment="oszacowanie zaleznosci dla przedzialu 100-600K: Lukasz Piskorski";
	}
	return ( 0.0258*pow(iT/300.,0.84) );
}
//------------------------------------------------------------------------------
double powietrze::cp(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 6, pp. 1 (in pdf: 983)";
		ipRef->comment="-";
	}
	return ( 1.007e3 );
}
//------------------------------------------------------------------------------
double powietrze::g(double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 6, pp. 1 (in pdf: 983)";
		ipRef->comment="-";
	}
	return ( 1.161 );
}
//------------------------------------------------------------------------------
double powietrze::dc(reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="-";
	}
	return ( 1. );
}
//------------------------------------------------------------------------------
double powietrze::nR(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="David R. Lide, ed.";
		ipRef->title="CRC Handbook of Chemistry and Physics, Internet Version 2005, <http://www.hbcpnetbase.com>";
		ipRef->journal="CRC Press, Boca Raton, FL, 2005, section 10, pp. 224 (in pdf: 1711)";
		ipRef->comment="ze zlozonego wzoru wychodzi 1.0002-1.0003 dla przedzialu dlugosci fal 0.2-2 um";
	}
	return ( 1. );
}
//------------------------------------------------------------------------------
double powietrze::abs(double iLam, double iT, reference *ipRef)
{
	if(ipRef!=NULL)
	{
		ipRef->reset();
		ipRef->author="-";
		ipRef->title="-";
		ipRef->journal="-";
		ipRef->comment="przyjeto 0";
	}
	return ( 0. );
}
//---------------------------------------------------------------------------
powietrze::powietrze()
{  
}
//---------------------------------------------------------------------------
powietrze::~powietrze()
{
}