#ifndef ZPRSMESA_CONSTANTS_HPP
#define ZPRSMESA_CONSTANTS_HPP

#include <cmath>

#ifndef M_PI
#   define M_PI 3.14159265358979323846
#endif

namespace cMath {
    const double pi = M_PI;
}


namespace cPhys
{
    const double e = 1.60217733e-19;            // elementary charge [C]
    const double c = 299792458.;                // speed of light [m/s]
    const double m0 = 9.10938291e-31;           // free electron mass [kg]
    const double mu0 = 4e-7*M_PI;               // vacuum permeability [V*s/A/m]
    const double epsilon0 = 1./mu0/c/c;         // vacuum permittivity [F/m]
    const double h_J = 6.62606957e-34;          // Planck's constant [J*s]
    const double h_eV = 4.135667516e-15;        // Planck's constant [eV*s]
    const double hb_J = 0.5*h_J/M_PI;           // Dirac's constant [J*s]
    const double hb_eV = 0.5*h_eV/M_PI;         // Dirac's constant [eV*s]
    const double SB = 5.670373e-8;              // Stefan-Boltzmann constant [W/m^2/K^4]
    const double kB_J = 1.3806503e-23;          // Boltzmann constant [J/K]
    const double kB_eV = 8.6173423e-5;          // Boltzmann constant [eV/K]
    const double h_eVc1e9 = 1239.84193009;      // h_eV*c*1e9 [eV*m]
}

namespace cDDM // constants used in drift-diffusion model
{
        const double
        BigNum = 1e15,                  // For boundary conditions
        PsiRef = 12.,                   // Reference Psi
        RT = 300.;                      // Room temperature
        //PsiCorrNPrec = 1e-5,          // Not Precise Psi Correction (FEM::setNodePsiStart, FEM::setContNodePsi)
        //PsiCorrPrec = 1e-10;          // Precise Psi Correction (FEM::setContNodePsi)

        //const int
        //      PsiLoopNPrec = 10000,   // Max Loop of Potential Not Precise Calculation (FEM::setContNodePsi)
        //      PsiLoopPrec = 1000000;  // Max Loop of Potential Precise Calculation (FEM::setNodePsiStart, FEM::setContNodePsi)
}


#endif
