#include "functions.h"

#include "Faddeeva.hh"

namespace cFunc {


double JtoeV(double iJ)
{
        return ( iJ/cPhys::e );
}


double LamtoE(double iLam)
{
        return ( JtoeV(cPhys::h_J*cPhys::c*1e9/iLam) );
}


double Varshni(double iEg0K, double iAlfa, double iBeta, double iT)
{
        return ( iEg0K - iAlfa*iT*iT/(iT+iBeta) );
}


double Nc(double iT, double iMe)
{
        return ( 2.*pow(2.*cMath::pi*iMe*cPhys::m0*cPhys::kB_J*iT/(cPhys::h_J*cPhys::h_J),1.5) );
}


double Nv(double iT, double iMh)
{
        return ( 2.*pow(2.*cMath::pi*iMh*cPhys::m0*cPhys::kB_J*iT/(cPhys::h_J*cPhys::h_J),1.5) );
}


double ni(double iT, double iMe, double iMh, double iEg)
{
        return ( sqrt(Nc(iT,iMe)*Nv(iT,iMh))*exp(-iEg/(2.*cPhys::kB_eV*iT)) );
}


double Nact(char iType, double iEact, double iN, double iM, double iT)
{
        if (iType == 'n')
        {
                double gD = 2.;
                double iNprim = Nc(iT, iM) * exp(-iEact/(cPhys::kB_eV*iT));
                return ( iNprim / (2.*gD) * (sqrt(1.+4.*gD*iN/iNprim) - 1.) );
        }
        else if (iType == 'p')
        {
                double gA = 4.;
                double iPprim = Nv(iT, iM) * exp(-iEact/(cPhys::kB_eV*iT));
                return ( iPprim / (2.*gA) * (sqrt(1.+4.*gA*iN/iPprim) - 1.) );
        }
        else return 0.;
}


double IntFD12(double iEta)
{
        double tKsi = pow(iEta,4.) + 33.6 * iEta * ( 1. - 0.68 * exp( -0.17 * ( iEta + 1. ) * ( iEta + 1. ) ) ) + 50. ;
        return ( 0.5 * sqrt(cMath::pi) / ( 0.75 * sqrt(cMath::pi) * powl(tKsi,-0.375) + exp(-iEta) ) );
}


double N(double iNc, double iFn, double iPsi, double iChi, double iT)
{
        return ( iNc * (2./sqrt(cMath::pi)) * IntFD12((iFn-cDDM::PsiRef+iPsi+iChi)/(cPhys::kB_eV*iT)) );
}


double P(double iNv, double iPsi, double iChi, double iEg, double iFp, double iT)
{
        return ( iNv * (2./sqrt(cMath::pi)) * IntFD12((cDDM::PsiRef-iPsi-iChi-iEg-iFp)/(cPhys::kB_eV*iT)) );
}


double getOptPar(std::string iPar, double iLam, int n, std::vector<double> &fmat, std::vector<double> &GAMMAmat, std::vector<double> &wmat, std::vector<double> &sigmamat)
{
        std::vector<double> w(n+1), f(n+1), GAMMA(n+1), sigma(n+1);
        // conversion of constants
        w[0] = (cPhys::e/cPhys::hb_J)*wmat[0]; // wp
        f[0] = fmat[0];
        GAMMA[0] = (cPhys::e/cPhys::hb_J)*GAMMAmat[0];
        for (int i=1; i<=n; ++i)
        {
                w[i] = (cPhys::e/cPhys::hb_J)*wmat[i];
                f[i] = fmat[i];
                GAMMA[i] = (cPhys::e/cPhys::hb_J)*GAMMAmat[i];
                sigma[i] = (cPhys::e/cPhys::hb_J)*sigmamat[i];
        }

        double OMEGA_P = sqrt(f[0])*w[0];
        double omega = 2.*cMath::pi*cPhys::c/(iLam*1e-9);

        std::complex<double> ii = std::complex<double>(0.,1.); // i

        std::complex<double> epsf = 1. - (OMEGA_P*OMEGA_P)/(omega*(omega + ii*GAMMA[0])); // first component of relative permittivity
        std::complex<double> epsb = std::complex<double>(0.,0.); // second component of relative permittivity
        for (int k=1; k<=n; ++k)
        {
                std::complex<double> a = std::sqrt(omega*omega + ii*omega*GAMMA[k]);
                std::complex<double> zplus = (a+w[k])/(sqrt(2.)*sigma[k]);
                std::complex<double> zminus = (a-w[k])/(sqrt(2.)*sigma[k]);
                epsb += ((ii*sqrt(cMath::pi)*f[k]*w[0]*w[0])/(2.*sqrt(2.)*a*sigma[k]))*(Faddeeva::erf(zplus)+Faddeeva::erf(zminus));
        }

        std::complex<double> eps_j = epsf + epsb; // total permittivity
        double epsRe = eps_j.real();
        double epsIm = eps_j.imag();
        double nR = sqrt((sqrt(epsRe*epsRe+epsIm*epsIm)+epsRe)/2.);
        double ext = sqrt((sqrt(epsRe*epsRe+epsIm*epsIm)-epsRe)/2.);
        double abs = 4*cMath::pi*ext/(iLam*1e-7); // [1/cm]

        if (iPar == "nR") return nR;
        else if (iPar == "abs") return abs;
        else if (iPar == "ext")	return ext;
        else if (iPar == "eps1") return epsRe;
        else if (iPar == "eps2")return epsIm;
        else return -1.;
}


} // namespace cFu
