#ifndef ZPRSMESA_FUNCTIONS_H
#define ZPRSMESA_FUNCTIONS_H

#include <complex>
#include <vector>
#include <cmath>
#include "constants.h"

namespace cFunc {

/// J -> eV
double JtoeV(double iJ);

/// Lam (nm), E (eV)
double LamtoE(double iLam);

/// Eg0K(eV), alfa(eV/K), beta(K), Eg(K)
double Varshni(double iEg0K, double iAlfa, double iBeta, double iT);

/// T(K), me(m0), Nc(1/m^3)
double Nc(double iT, double iMe);

/// T(K), mh(m0), Nc(1/m^3)
double Nv(double iT, double iMh);

/// T(K), me(m0), mh(m0), Eg(eV), ni(1/m^3)
double ni(double iT, double iMe, double iMh, double iEg);

/// Type(-), Eact(eV), N(1/m^3), M(m0), T(K), Nact(1/m^3) (we can calculate carrier conc. when we know the activation energy)
double Nact(char iType, double iEact, double iN, double iM, double iT);

/// Fermi-Dirac integral
double IntFD12(double iEta);

/// electron concentration (for drift-diffusion model)
double N(double iNc, double iFn, double iPsi, double iChi, double iT);

/// hole concentration (for drift-diffusion model)
double P(double iNv, double iPsi, double iChi, double iEg, double iFp, double iT);

/// Brendel-Bormann model (A.D. Rakic, et. al., Appl. Opt., 37 (22), 5271-5283, 1998)
double getOptPar(std::string iPar, double iLam, int n, std::vector<double> &fmat, std::vector<double> &GAMMAmat,
                 std::vector<double> &wmat, std::vector<double> &sigmamat);


/// namespace cFunc
}

#endif
