#include "materials.hpp"

#include "MaterialDataBase/material_headers.h"

#include "MaterialDataBase/material.h"
// #include "MaterialDataBase/material_interface.h"

REGISTER_SIMPLE(Ag);
REGISTER_SIMPLE(Al);
REGISTER_SIMPLE(AlAs);
REGISTER_TERTIARY(AlAsP, As);
REGISTER_TERTIARY_DOPED(AlAsSb, As, Te);
REGISTER_TERTIARY_DOPED(AlGaAs, Al, Si, C, Zn, Be, Te, Se);
REGISTER_QUATERNARY(AlGaAsSb, Al, As);
REGISTER_QUATERNARY(AlGaInAs, Al, Ga);
REGISTER_QUATERNARY_DOPED(AlGaInP, Al, Ga, Si, Zn, Se, Be);
REGISTER_TERTIARY_DOPED(AlGaN, Al, Si, Mg);
REGISTER_TERTIARY(AlGaP, Al);
REGISTER_TERTIARY(AlGaSb, Al);
REGISTER_TERTIARY(AlInAs, Al);
REGISTER_TERTIARY(AlInP, Al);
REGISTER_TERTIARY(AlInSb, Al);
REGISTER_NITRIDE_DOPED(AlN, Si, Mg);
REGISTER_SIMPLE(AlNzb);
REGISTER_SIMPLE(AlP);
REGISTER_TERTIARY(AlPSb, P);
REGISTER_SIMPLE(AlSb);
REGISTER_SIMPLE(AlxOy);
REGISTER_SIMPLE(aSi);
REGISTER_SIMPLE(aSiO2);
REGISTER_SIMPLE(Au);
REGISTER_SIMPLE(AuGe);
REGISTER_SIMPLE(BCB);
REGISTER_SIMPLE(Be);
REGISTER_SIMPLE(Cr);
REGISTER_BINARY_DOPED(cSi, P, As, Sb, B);
REGISTER_SIMPLE(Cu);
REGISTER_SIMPLE(GaAs);
REGISTER_TERTIARY(GaAsP, As);
REGISTER_TERTIARY(GaAsSb, As);
REGISTER_QUATERNARY(GaInAsP, Ga, As);
REGISTER_QUATERNARY(GaInAsSb, Ga, As);
REGISTER_QUATERNARY(GaInNAs, Ga, N);
REGISTER_TERTIARY_DOPED(GaInP, Ga, Si, Zn, Se, Sn, C, Be, Cd);
REGISTER_TERTIARY(GaInSb, Ga);
REGISTER_NITRIDE_DOPED(GaN, Si, Mg, O);
REGISTER_TERTIARY(GaNAs, N);
REGISTER_SIMPLE(GaNzb);
REGISTER_SIMPLE(GaP);
REGISTER_TERTIARY(GaPSb, P);
REGISTER_SIMPLE(GaSb);
REGISTER_SIMPLE(In);
REGISTER_QUATERNARY(InAlGaN, In, Al);
REGISTER_SIMPLE(InAs);
REGISTER_TERTIARY(InAsP, As);
REGISTER_TERTIARY(InAsSb, As);
REGISTER_TERTIARY_DOPED(InGaAs, In, Si, C, Zn, Be, Te, Se, Sn);
REGISTER_TERTIARY_DOPED(InGaN, In, Si, Mg);
REGISTER_NITRIDE_DOPED(InN, Si, Mg);
REGISTER_SIMPLE(InNzb);
REGISTER_BINARY_DOPED(InP, Si, Zn, Be, C, Te, S);
REGISTER_TERTIARY(InPSb, P);
REGISTER_SIMPLE(InSb);
REGISTER_SIMPLE(ITO);
REGISTER_SIMPLE(Ni);
REGISTER_SIMPLE(Pd);
REGISTER_SIMPLE(powietrze);
REGISTER_SIMPLE(Pt);
REGISTER_SIMPLE(Si3N4);
REGISTER_SIMPLE(Ti);
REGISTER_SIMPLE(W);

REGISTER_SIMPLE(aGe);
REGISTER_SIMPLE(AlInN);
REGISTER_SIMPLE(Ge);
REGISTER_SIMPLE(HfO2);
REGISTER_SIMPLE(Nb2O5);
REGISTER_SIMPLE(Si);
REGISTER_SIMPLE(SiNx);
REGISTER_SIMPLE(SiO2);
REGISTER_SIMPLE(TiO2);
